#define FUNCTION_ID 0
#define CODE_ID 1
#define CONSTANTS_ID 2
#define IMPORT_ID 3

//typy konstant
#define	INT_CONST 0
#define ZSTRING_CONST 1
#define DOUBLE_CONST 2
#define VOID_TYPE 3

#define LOCAL_FUNCTION 0
#define EXTERN_FUNCTION 1

struct IMPORT
{
	char*			name;
	char*			library;
	char			type;
};

//hlavicka funkce
struct FUNCTION_HEADER
{
		char*				name;		//jmeno funcke
		unsigned short		inputs;		//pocet vstupnich parametru
		unsigned short		ouputs;		//vracenych hodnot, bud 0 nebo 1
		unsigned short		localsLimit;
		unsigned short		stackLimit;	
		unsigned int		startCode;	//adresa do kodoveho segmentu kde kod zacina
		unsigned int		endCode;	//odresa do kodoveho segmentu kde kod konci
};

struct	CONSTANT
{
	char				type;
	union
	{
		int				intval;
		char*			str;
		double			doubleval;
	} val;

	bool				operator == (CONSTANT& right)
	{
		if ((type == INT_CONST) && (right.type == INT_CONST))
		{
			return (val.intval == right.val.intval) ? true : false;
		}
		else if ((type == DOUBLE_CONST) && (right.type == DOUBLE_CONST))
		{
			return (val.doubleval == right.val.doubleval) ? true : false;
		}
		else if ((type == ZSTRING_CONST) && (right.type == ZSTRING_CONST))
		{
			return (strcmp(val.str,right.val.str) == 0) ? true : false;
		}
		else
			return false;
	}
};